/*
 * CPulldownList.java
 *
 * AvJX^pl v_EXg
 *
 * Copyright ITmarks Inc. All rights reserved.
 */
package iappli.lib.ui;

import com.nttdocomo.ui.Graphics;
import com.nttdocomo.ui.Image;

/**
 * Canvasɕ`悷郊Xg{bNXłB<br>
 * 
 * {łł́AʃTCYlĂ܂B
 * {izu郌CAEglĂpB<br>
 *
 * <pre>
 * yz
 * class Test extends CostumePanel {
 *   String list[] = {"eXg1", "eXg2", "eXg3"};
 *   CPulldownList ls = new CPulldownList(list);
 *
 *   public void paint(Graphics g) {
 *
 *     ls.show(g, 3, 1, 15, true);
 *     addEvent(ls);
 *         F
 *   }
 *   public void processEvent2(CComponent c, int t, int p) {
 *     if (c == ls &&
 *       t == CostumePanel.SELECTION_CHANGED) {
 *       System.out.println(((CPulldownList)c).getSelectedItem());
 *     }
 *   }
 * }
 * </pre>
 */
public final class CPulldownList extends iappli.lib.ui.CComponent {

    /**
     * v_EXg𐶐܂B<br>
     */
    public CPulldownList() {
        this(null);
    }

    /**
     * Xgw肵ăv_EXg𐶐܂B<br>
     *
     * @param list Xgw肵܂B
     */
    public CPulldownList(String[] list) {
        this.list  = list;
    }

    /**
     * XgAOiFAwiFAetFw肵ăv_EXg𐶐܂B<br>
     *
     * @param list Xgw肵܂B
     * @param c1   OiFw肵܂B
     * @param c2   wiFw肵܂B
     * @param s    etFw肵܂B
     */
    public CPulldownList(String[] list,
                         int      c1,
                         int      c2,
                         int      s)
    {
        this(list);

        super.fgcolor = c1;
        super.bgcolor = c2;
        super.setShadow(s);
    }

    /**
     * v_EXg̃Xgݒ肵܂B<br>
     *
     * @param list v_EXg̃Xgw肵܂B
     */
    public void setList(String[] list) {
        this.list = list;
    }

    /**
     * IĂ鍀ڂԂ܂B<br>
     * 
     * @return IĂ鍀ڂԂ܂B
     */
    public String getSelectedItem() {
        return list[selno];
    }

    /**
     * IĂ鍀ڂ̈ʒuԂ܂B<br>
     * 
     * @return IĂ鍀ڂ̈ʒuԂ܂B
     */
    public int getSelectedIndex() {
        return selno;
    }

    /**
     * Xg̓̈ʒu̍ڂI܂B<br>
     * @param index Xg̈ʒuw肵܂BO`
     */
    public void select(int index) {
        // Xg̏𒴂ĂŌI
        if (list.length <= index) {
            index = list.length - 1;
        }
        // ̐l͍ŏI
        if (index < 0) {
            index = 0;
        }
        selno = index;
    }

    /**
     * v_EXg`悵܂B<br>
     * 
     * Xg̐╝c/𒴂ꍇ̍l͂܂B
     * \ȃTCYmۂĂB<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock s܂B
     * ĂяoɂĎsĂB
     *
     * @param g LpX̃OtBbNXIuWFNg(this.getGraphics())w肵܂B
     * @param x W()w肵܂B
     * @param y cW()w肵܂B
     * @param w ()w肵܂B
     * @param b truew肷ƕ`OobNAbv܂B
     *           (q[v邽ߎgȂꍇ false w肵ĂB)
     */
    public void show(Graphics g, int x, int y, int w, boolean b) {
        
        // `ς݂폜
        clear();

        // 擾
        int fw = super.f.getBBoxWidth (" "); // tHg̉
        int fh = super.f.getBBoxHeight(" "); // tHg̏c

        // W𕶎Ŏw
        x = x * fw;
        y = y * fh;
        w = w * fw;

        synchronized (this) {
            // ޔ
            super.x = x;
            super.y = y;
            super.w = w;
            super.h = fh;
            super.backup = b;
            super.g = g;
        }
        
        // obNAbvL̏ꍇACanvas̉摜ޔ
        super.backupImage();

        /*
         * v_EXg`
         */
        // wi
        g.setColor(super.bgcolor);
        g.fillRect(x, y, super.w, super.h);
        int pd[] = g.getRGBPixels(x, y, super.w, super.h, null, 0);
        textArea = Image.createImage(super.w, super.h, pd, 0);

        // A̘g
        g.setColor(Graphics.getColorOfName(Graphics.BLACK));
        g.drawLine(x-1, y-1, x+super.w, y-1);               // 
        g.drawLine(x-1, y-1, x-1, y+super.h);               // 
        g.setColor(Graphics.getColorOfName(Graphics.GRAY));
        g.drawLine(x-2, y-2, x+super.w+1, y-2);             // 
        g.drawLine(x-2, y-2, x-2, y+super.h+1);             // 

        // AE̘g
        g.setColor(Graphics.getColorOfName(Graphics.GRAY));
        g.drawLine(x-1, y+super.h, x+super.w, y+super.h);   // 
        g.drawLine(x+super.w, y-1, x+super.w, y+super.h);   // E
        g.setColor(Graphics.getColorOfRGB(240, 240, 240));
        g.drawLine(x-2, y+super.h+1, x+super.w+1, y+super.h+1); // 
        g.drawLine(x+super.w+1, y-2, x+super.w+1, y+super.h+1); // E

        // v_E{^
        // AE̘g
        int x1 = x + super.w+4;
        g.setColor(Graphics.getColorOfName(Graphics.SILVER));
        g.fillRect(x1, y, fw*2, fh);

        g.setColor(Graphics.getColorOfName(Graphics.GRAY));
        g.drawLine(x1-1, y+fh, x1+fw*2, y+fh);              // 
        g.drawLine(x1+fw*2, y-1, x1+fw*2, y+fh);            // E
        g.setColor(Graphics.getColorOfName(Graphics.BLACK));
        g.drawLine(x1-2, y+fh+1, x1+fw*2+1, y+fh+1);        // 
        g.drawLine(x1+fw*2+1, y-2, x1+fw*2+1, y+fh+1);      // E

        // A̘g
        g.setColor(Graphics.getColorOfRGB(220, 220, 220));
        g.drawLine(x1-1, y-1, x1+fw*2, y-1);                // 
        g.drawLine(x1-1, y-1, x1-1, y+fh);                  // 
        g.setColor(Graphics.getColorOfName(Graphics.WHITE));
        g.drawLine(x1-2, y-2, x1+fw+1, y-2);                // 
        g.drawLine(x1-2, y-2, x1-2, y+fh+1);                // 

        int x2[] = {x1+1, x1+fw*2-3, x1+fw*2/2-1, x1+1};
        int y2[] = {y+3,  y+3,       y+fh-3,      y+3};
        g.setColor(Graphics.getColorOfName(Graphics.BLACK));
        g.fillPolygon(x2, y2, 4);
        g.setColor(Graphics.getColorOfName(Graphics.GRAY));
        g.drawPolyline(x2, y2, 4);

        this.w += fw*2+4;
        
        // eLXg̕\
        writeText();
    }

    /**
     * v_E`悵܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B
     */
    protected void openPullDown() {
        super.g.lock();

        // 擾
        int fh = super.f.getBBoxHeight(" "); // tHg̏c
                                             // tHgx[XC̎擾 (@ˑ)
        int bl = (super.f.getHeight() - super.f.getAscent() - 2) * -1;

        // Xg`̈̃NA
        if (imp != null) {
            super.g.drawImage(imp, super.x-1, super.y+fh+2);
        }

        // v_EOobNAbv
        int pd[] = g.getRGBPixels(super.x-1, super.y+fh+2, super.w+2,
                                  fh*list.length+2, null, 0);
        imp = Image.createImage(super.w+2, fh*list.length+2, pd, 0);

        // wi
        super.g.setColor(super.bgcolor);
        super.g.fillRect(super.x, super.y+fh+2, super.w, fh*list.length+2);

        // g
        super.g.setColor(Graphics.getColorOfName(Graphics.BLACK));
        super.g.drawRect(super.x-1, super.y+fh+2, super.w+1, fh*list.length+1);

        // Ig̕`
        super.g.setColor(Graphics.getColorOfRGB(255, 255, 100, 150));
        super.g.fillRect(super.x, super.y+bl+fh*(selno+1)+3, super.w, fh);

        // Xg` (`̈敪̂ݕ\)
        int py = y+fh+3;
        for (int i = 0; i < list.length; i++) {
            if (super.sdflag) {
                // Xg̉et`
                super.g.setColor(super.sdcolor);
                super.g.drawString(list[i], super.x+2, py+fh+bl-1);
            }

            // Xg`
            super.g.setColor(super.fgcolor);
            super.g.drawString(list[i], super.x+1, py+fh+bl-2);
            py += fh;
        }

        super.g.unlock(true);
    }

    /**
     * v_EN[Y܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B
     */
    protected void closePullDown() {
        super.g.lock();

        // v_EÕobNobt@`
        int fh = super.f.getBBoxHeight(" "); // tHg̏c
        super.g.drawImage(imp, super.x-1, super.y+fh+2);
        // eLXg\
        writeText();

        super.g.unlock(true);
    }

    /**
     * IꂽXg̃eLXg`悵܂B<br>
     */
    protected void writeText() {
        // 擾
        int fh = super.f.getBBoxHeight(" "); // tHg̏c
                                             // tHgx[XC̎擾 (@ˑ)
        int bl = (super.f.getHeight() - super.f.getAscent() - 2) * -1;

        // eLXg`̈̃NA
        super.g.drawImage(textArea, super.x, super.y);

        // eLXg` (`̈敪̂ݕ\)
        if (super.sdflag) {
            // eLXg̉et`
            super.g.setColor(super.sdcolor);
            super.g.drawString(list[selno], super.x+2, super.y+fh+bl-1);
        }
        // eLXg`
        super.g.setColor(super.fgcolor);
        super.g.drawString(list[selno], super.x+1, super.y+fh+bl-2);
    }

    /**
     * tH[JXݒ肵܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B
     */
    protected void setFocus() {
        // obNobt@ɃtH[JXỎ摜obNAbv
        int fw = super.f.getBBoxWidth(" ");  // tHg̉
        int pd[] = g.getRGBPixels(x-5, y-5, super.w+fw*2+14, super.h+10, null, 0);
        imf = Image.createImage(super.w+fw*2+14, super.h+10, pd, 0);

        // tH[JX`
        super.g.lock();
        super.g.setColor(Graphics.getColorOfName(Graphics.BLUE));
        super.g.drawRect(super.x-5, super.y-5, super.w+9, super.h+9);
        super.g.drawRect(super.x-4, super.y-4, super.w+7, super.h+7);
        super.g.unlock(true);
    }

    /**
     * tH[JX폜܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B
     */
    protected void resetFocus() {
        // tH[JXÕobNobt@`
        super.g.lock();
        super.g.drawImage(imf, super.x-5, super.y-5);

        // ύXꂽeLXg`
        writeText();

        super.g.unlock(true);
        imf = null;
    }

    /**
     * iIANVs܂B<br>
     * @return Cxg̃^CvԂ܂B
     *          Cxg̔΁A-1 Ԃ܂B
     */
    protected int actionSelect() {
        // v_EĂꍇ
        if (selflag) {
            // v_EXg
            closePullDown();
            selflag = false;
            return CostumePanel.SELECTION_CHANGED;
        }
        // v_EĂȂꍇ
        else {
            // v_EXgJ
            openPullDown();
            selflag = true;
        }

        return -1;
    }

    /**
     * ړANVs܂B<br>
     * @param num ANVԍn܂B-1:O 1:
     * @return v_EĂ true Ԃ܂B
     */
    protected boolean actionPosition(int num) {
        // v_EĂꍇ
        if (selflag) {
            // PO܂͂PI
            select(getSelectedIndex()+num);
            openPullDown();
        }
        return selflag;
    }

    
    /*
     * `
     */
    private String[]  list;             // Xg
    private Image     textArea = null;  // eLXg\̈̉摜
    private Image     imf      = null;  // tH[JXO摜
    private Image     imp      = null;  // v_EO摜
    private int       selno    = 0;     // Iԍ
    private boolean   selflag  = false; // XgIꂽ
}
