/*
 * CCheckList.java
 *
 * AvJX^pl WI{^ƃ`FbN{bNX
 *
 * Copyright ITmarks Inc. All rights reserved.
 */
package iappli.lib.ui;

import com.nttdocomo.ui.Graphics;
import com.nttdocomo.ui.Image;

/**
 * Canvasɕ`悷郉WI{^̓`FbN{bNXłB<br>
 * 
 * {łł́AʃTCYlĂ܂B
 * ̂߁ACAEglĂpB<br>
 *
 * <pre>
 * yz
 * class Test extends CostumePanel {
 *   String list[] = {"AAA", "", "PQR", "ABC"};
 *
 *   CCheckList ck = new CCheckList(
 *           CCheckList.CHECKBOX,
 *           list,
 *           Graphics.getColorOfName(Graphics.BLACK),
 *           Graphics.getColorOfRGB(200, 200, 200, 200),
 *           Graphics.getColorOfName(Graphics.WHITE));
 *
 *   public void paint(Graphics g) {
 * 
 *     ck.show(g, 3, 3, 3, 8, true);
 *     addEvent(ck);
 *         F
 *   }
 *
 *   public void processEvent2(CComponent c, int t, int p) {
 *     if (c == ck &&
 *         t == CostumePanel.SELECTION_CHANGED) {
 *       int x[] = ((CCheckList)c).getCheckIndex();
 *       for (int i = 0; i < x.length; i++) {
 *         System.out.println("SELECT:"+x[i]);
 *       }
 *     }
 *   }
 * }
 * </pre>
 */
public final class CCheckList extends iappli.lib.ui.CComponent {

    /**
     * WI{^\܂(={@value})B<br>
     * ListBox#RADIO_BUTTON ɓłB
     */
    public static final int RADIO_BUTTON = 1;

    /**
     * `FbN{bNX\܂(={@value})B<br>
     * ListBox#CHECKBOX ɓłB
     */
    public static final int CHECKBOX = 2;

    /**
     * `FbN{bNX𐶐܂B<br>
     * @param type Xg̃^Cvw肵܂B
     */
    public CCheckList(int type) {
        this(type, null);
    }

    /**
     * Xgw肵ă`FbN{bNX𐶐܂B<br>
     *
     * @param type Xg̃^Cvw肵܂B
     * @param list Xgw肵܂B
     */
    public CCheckList(int      type,
                      String[] list) {
    	this.type = type;
        this.list = list;
        this.listCheck = new boolean[list.length];
    }

    /**
     * XgAOiFAwiFAetFw肵ă`FbN{bNX𐶐܂B<br>
     *
     * @param type Xg̃^Cvw肵܂B
     * @param list Xgw肵܂B
     * @param c1   OiFw肵܂B
     * @param c2   wiFw肵܂B
     * @param s    etFw肵܂B
     */
    public CCheckList(int      type,
    		      String[] list,
                      int      c1,
                      int      c2,
                      int      s)
    {
        this(type, list);

        super.fgcolor = c1;
        super.bgcolor = c2;
        super.setShadow(s);
    }

    /**
     * `FbN{bNX̃Xgݒ肵܂B<br>
     *
     * @param list `FbN{bNX̃Xgw肵܂B
     */
    public void setList(String[] list) {
        this.list = list;
        this.listCheck = new boolean[list.length];
    }

    /**
     * `FbNĂ鍀ڂ̔ԍzŕԂ܂B<br>
     * 
     * WI{^̏ꍇ́AẑPԖڂɂȂ܂B<br>
     * 
     * @return `FbNĂ鍀ڔԍ̔zԂ܂B
     *          ڔԍ́Â܂ܐ̃Xg̔zɑΉ܂B
     *          `FbNꍇ́A̔z񂪕Ԃ܂B
     */
    public int[] getCheckIndex() {
        int num = 0;
        // `FbN̂鍀ڐJEg
        for (int i = 0; i < list.length; i++) {
            if (listCheck[i]) {
                num++;
            }
        }
        // `FbN̂鍀ڂXgAbv
        int lists[] = new int[num];
        num = 0;
        for (int i = 0; i < list.length; i++) {
            if (listCheck[i]) {
                lists[num] = i;
                num++;
            }
        }
        return lists;
    }

    /**
     * IitH[JXjĂ鍀ڂ̈ʒuԂ܂B<br>
     * 
     * @return IĂ鍀ڂ̈ʒuԂ܂B
     */
    public int getSelectedIndex() {
        return selno;
    }

    /**
     * Xg̍ڐԂ܂B<br>
     * 
     * @return IĂ鍀ڂ̈ʒuԂ܂B
     */
    public int getLength() {
        return list.length;
    }

    /**
     * Xg̓̈ʒu̍ڂI܂B<br>
     * 
     * @param index I鍀ڂ̈ʒuw肵܂B 0 `
     */
    public void select(int index) {
        // Xg̏𒴂烊Xg̍ŌI
        if (list.length <= index) {
            index = list.length -1;
        }
        // ̐l̓Xg̍ŏI
        if (index < 0) {
            index = 0;
        }
        selno = index;
    }

    /**
     * WI{^̓`FbN{bNX`悵܂B<br>
     * 
     * WI{^F̍ڂPI郊XgłB<br>
     * `FbN{bNXF̍ڂ畡I郊XgłB<br>
     * IꂽڂɂẮACCheckList{@link #getCheckIndex()}ŁA
     * ڔԍ擾ł܂Bڔԍ́ÃXg̔zɑΉ܂B<br>
     * 
     * Xg̐╝ʃTCY𒴂ꍇ̍l͂܂B
     * rowsAw Ɏw肷lɒӂĂB<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock s܂B
     * ĂяoɂĎsĂB<br>
     * 
     * <pre>
     * (x, y)
     * 
     *      
     *  12345678  
     *  bw(8)b
     * b||||@ rows(3) @||||b
     * </pre>
     *
     * @param g LpX̃OtBbNXIuWFNg(getGraphics())w肵܂B
     * @param x W()w肵܂B
     * @param y cW()w肵܂B
     * @param rows ɕ\`FbN{bNX̌w肵܂B
     * @param w ()w肵܂B
     * @param b truew肷ƕ`OobNAbv܂B
     *           (q[v邽ߎgȂꍇ false w肵ĂB)
     */
    public void show(Graphics g, int x, int y, int rows, int w, boolean b) {
        
        // `ς݂폜
        clear();

        // 擾
        int fw = super.f.getBBoxWidth(" ");  // tHg̉
        int fh = super.f.getBBoxHeight(" "); // tHg̏c
                                             // tHgx[XC̎擾 (@ˑ)
        int bl = (super.f.getHeight() - super.f.getAscent() - 2) * -1;

        // W𕶎Ŏw
        x = x * fw;
        y = y * fh;

        synchronized (this) {
            this.rows = rows;

            // ޔ
            super.x = x;
            super.y = y;
            super.backup = b;
            super.g = g;

            // obNAbvL̏ꍇACanvas̉摜ޔ
            // `̈ŜobNAbv
            super.w = (w*fw+fh+2) * rows;
            super.h = fh * (list.length / rows + 1);
            super.backupImage();

            super.w = w*fw+fh+2;        // `FbN{bNXł͉̌
            super.h = fh;
        }

        /*
         * Xg`
         */
        for (int x1 = x, y1 = y, i = 0; i < list.length; i++,
            x1 = super.x + (i % rows) * (super.w  + 10),
            y1 = super.y + (i / rows) * (super.h + 10)) {
            // eLXg
            if (super.sdflag) {
                // eLXg̉et`
                g.setColor(super.sdcolor);
                g.drawString(list[i], x1+fh+2, y1+fh+bl-1);
            }
            // eLXg`
            g.setColor(super.fgcolor);
            g.drawString(list[i], x1+fh+2, y1+fh+bl-2);
        }
        // WI{^̏ꍇAŏ̍ڂ̓`FbN
        if (type == CCheckList.RADIO_BUTTON) {
            listCheck[0] = true;
        }
        // Xg̃{^`
        checkRePaint();
    }

    /**
     * Xg̃tH[JXꂽʒũ`FbN{bNXɃ`FbNt܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B
     */
    public void check() {
        this.check(selno);
    }

    /**
     * Xg̓̈ʒũ`FbN{bNXɃ`FbNt܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B<br>
     * 
     * @param num `FbNt郊Xg̔zԍw肵܂B
     */
    public void check(int num) {
        super.g.lock();

        /*
         * `FbN
         */
        // WI{^
        if (type == CCheckList.RADIO_BUTTON) {
            listCheck[checkNo] = false;
            checkNo = num;
            listCheck[checkNo] = true;
        }
        // `FbN{bNX
        else {
            listCheck[num] = !listCheck[num];
        }

        // {^ĕ`悷
        checkRePaint();

        super.g.unlock(true);
    }

    /**
     * tH[JXݒ肵܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B
     */
    protected void setFocus() {
        // ̃XgɃtH[JXΏ
        if (imf != null) resetFocus();

        // obNobt@ɃtH[JXỎ摜obNAbv
        int x1 = super.x + (selno % rows) * (w + 10); 
        int y1 = super.y + (selno / rows) * (h + 10);
        int pd[] = g.getRGBPixels(x1-5, y1-5, w+10, h+10, null, 0);
        imf = Image.createImage(w+10, h+10, pd, 0);

        // tH[JX`
        super.g.lock();
        super.g.setColor(Graphics.getColorOfName(Graphics.BLUE));
        super.g.drawRect(x1-5, y1-5, super.w+9, super.h+9);
        super.g.drawRect(x1-4, y1-4, super.w+7, super.h+7);
        super.g.unlock(true);
    }

    /**
     * tH[JX폜܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B
     */
    protected void resetFocus() {
        // tH[JXÕobNobt@`
        super.g.lock();
        super.g.drawImage(imf,
                          super.x + (selno % rows) * (w + 10)-5,
                          super.y + (selno / rows) * (h + 10)-5);
        // {^ĕ`悷
        checkRePaint();
        super.g.unlock(true);
        imf = null;
    }

    /**
     * Xg̃{^ĕ`悵܂B<br>
     * 
     * Xg`FbN̂nm/neeɂs܂B<br>
     */
    private void checkRePaint() {

        int fh = super.f.getBBoxHeight(" "); // tHg̏c

        for (int x1 = x, y1 = y, i = 0; i < list.length; i++,
             x1 = super.x + (i % rows) * (w + 10),
             y1 = super.y + (i / rows) * (h + 10)) {

            // WI{^ ()
            if (type == CCheckList.RADIO_BUTTON) {
                g.setColor(Graphics.getColorOfName(Graphics.SILVER));
                g.fillArc(x1, y1, fh, fh, 0, 360);
                g.setColor(Graphics.getColorOfName(Graphics.BLACK));
                g.drawArc(x1, y1, fh, fh, 0, 360);
                // `FbNt ()
                if (i == checkNo) {
                    g.setColor(Graphics.getColorOfName(Graphics.BLUE));
                    g.fillArc(x1+fh/4, y1+fh/4, fh/3+fh/3, fh/3+fh/3, 0, 360);
                }
            }
            // `FbN{bNX ()
            else {
                g.setColor(Graphics.getColorOfName(Graphics.WHITE));
                g.fillRect(x1, y1, fh, fh);
                g.setColor(Graphics.getColorOfName(Graphics.BLACK));
                g.drawRect(x1, y1, fh, fh);
                g.setColor(Graphics.getColorOfName(Graphics.GRAY));
                g.drawRect(x1+1, y1+1, fh-1, fh-1);
                // `FbNt ()
                if (listCheck[i]) {
                    g.setColor(Graphics.getColorOfName(Graphics.BLUE));
                    g.drawLine(x1+4, y1+4, x1+fh-6, y1+fh-4);
                    g.drawLine(x1+fh-6, y1+fh-4, x1+fh-4, y1+fh-6);
                    g.drawLine(x1+4, y1+5, x1+fh-6, y1+fh-3);
                    g.drawLine(x1+fh-6, y1+fh-3, x1+fh-4, y1+fh-6);
                }
            }
        }
    }

    /**
     * iIANVs܂B<br>
     * @return Cxg̃^CvԂ܂B
     */
    protected int actionSelect() {
        // `FbNt
        check();

        return CostumePanel.SELECTION_CHANGED;
    }

    /**
     * iړANVs܂B<br>
     * @param num ANVԍn܂B-1:O 1:
     * @return XgI𒆂Ȃ true Ԃ܂B
     */
    protected boolean actionPosition(int num) {
        // Xg̐擪łPO܂́AXg̍ŌłP
        if ((num == -1 && getSelectedIndex() == 0) ||
            (num ==  1 && getSelectedIndex() == getLength()-1)) {
            return false;
        }

        // PO܂͂PI
        resetFocus();
        select(getSelectedIndex()+num);
        setFocus();
        return true;
    }

    /*
     * `
     */
    private int       type;             // Xg̃^Cv
    private String[]  list;             // Xg
    private boolean[] listCheck;        // `FbNĂtO
    private int       checkNo = 0;      // WI{^̃`FbNʒu
    private Image     imf     = null;   // tH[JXO摜
    private int       selno   = 0;      // Iԍ
    private int       rows    = 0;      // ̌
}
