/*
 * CButton.java
 *
 * AvJX^pl {^
 *
 * Copyright ITmarks Inc. All rights reserved.
 */
package iappli.lib.ui;

import com.nttdocomo.ui.Graphics;
import com.nttdocomo.ui.Image;

/**
 * Canvasɕ`悷{^łB<br>
 *
 * <pre>
 * yz
 * class Test extends CostumePanel {
 *   CButton bt = new CButton("{^");
 * 
 *   public void paint(Graphics g) {
 *
 *     bt.show(g, 10, 10, true);
 *     addEvent(bt);
 *         F
 *   }
 * 
 *   public void processEvent2(CComponent c, int t, int p) {
 *     if (c == bt &&
 *         t == Display.KEY_PRESSED_EVENT &&
 *         p == Display.KEY_SELECT) {
 *           System.out.println("{^ꂽ");
 *     }
 *   }
 * }
 * </pre>
 */
public final class CButton extends iappli.lib.ui.CComponent {

    /**
     * {^𐶐܂B<br>
     */
    public CButton() {
        this(null);
    }

    /**
     * {^̃xw肵ă{^𐶐܂B<br>
     *
     * @param text {^̃xw肵܂B
     */
    public CButton(String  text) {
        this.text = text;
        if (this.text == null) {
            this.text = "";
        }

        /*
         * ftHglύX
         */
        super.bgcolor = Graphics.getColorOfName(Graphics.SILVER);
    }

    /**
     * {^̃xAOiFAetFw肵ă{^𐶐܂B<br>
     *
     * @param text xw肵܂B
     * @param c    OiFw肵܂B
     * @param s    etFw肵܂B
     */
    public CButton(String  text,
                   int     c,
                   int     s)
    {
        this(text);

        super.fgcolor = c;
        super.setShadow(s);
    }

    /**
     * {^̃xݒ肵܂B<br>
     *
     * @param text {^̃xw肵܂B
     *              null w肳ꂽꍇ͋󕶎("")ݒ肳܂B
     */
    public void setLabel(String text) {
        this.text = text;
        if (this.text == null) {
            this.text = "";
        }
    }

    /**
     * {^`悵܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock s܂B
     * ĂяoɂĎsĂB
     *
     * @param g LpX̃OtBbNXIuWFNg(getGraphics())w肵܂B
     * @param x W()w肵܂B
     * @param y cW()w肵܂B
     * @param b truew肷ƕ`OobNAbv܂B
     *           (q[v邽ߎgȂꍇ false w肵ĂB)
     */
    public void show(Graphics g, int x, int y, boolean b) {
        
        // `ς݂폜
        clear();

        // 擾
        int fw = super.f.getBBoxWidth(" ");  // tHg̉
        int fh = super.f.getBBoxHeight(" "); // tHg̏c
                                             // tHgx[XC̎擾 (@ˑ)
        int bl = (super.f.getHeight() - super.f.getAscent() - 2) * -1;

        // X,Y W𕶎Ŏw
        x = x * fw;
        y = y * fh;

        synchronized (this) {
            // ޔ
            super.x = x;
            super.y = y;
            super.w = fw * text.getBytes().length + 1;
            super.h = fh + 1;
            super.backup = b;
            super.g = g;
        }
        
        // obNAbvL̏ꍇACanvas̉摜ޔ
        super.backupImage();

        /*
         * {^`
         */
        // wi
        g.setColor(super.bgcolor);
        g.fillRect(x, y, w, h);


        // AE̘g
        g.setColor(Graphics.getColorOfName(Graphics.GRAY));
        g.drawLine(x-1, y+h, x+w, y+h);       // 
        g.drawLine(x+w, y-1, x+w, y+h);       // E
        g.setColor(Graphics.getColorOfName(Graphics.BLACK));
        g.drawLine(x-2, y+h+1, x+w+1, y+h+1); // 
        g.drawLine(x+w+1, y-2, x+w+1, y+h+1); // E

        // A̘g
        g.setColor(Graphics.getColorOfRGB(220, 220, 220));
        g.drawLine(x-1, y-1, x+w, y-1);       // 
        g.drawLine(x-1, y-1, x-1, y+h);       // 
        g.setColor(Graphics.getColorOfName(Graphics.WHITE));
        g.drawLine(x-2, y-2, x+w+1, y-2);     // 
        g.drawLine(x-2, y-2, x-2, y+h+1);     // 

        // {^̃x
        if (super.sdflag) {
            // {^̃xet`
            g.setColor(super.sdcolor);
            g.drawString(text, x+1, y+fh+bl-1);
        }
        // {^̃x`
        g.setColor(super.fgcolor);
        g.drawString(text, x, y+fh+bl-2);
    }
    
    /**
     * tH[JXݒ肵܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B
     */
    protected void setFocus() {
        // ̃XgɃtH[JXΏ
        if (imf != null) resetFocus();

        // obNobt@ɃtH[JXỎ摜obNAbv
        int pd[] = g.getRGBPixels(super.x-5,  super.y-5, super.w+10,
                                  super.h+10, null, 0);
        imf = Image.createImage(super.w+10, super.h+10, pd, 0);

        // tH[JX`
        super.g.lock();
        super.g.setColor(Graphics.getColorOfName(Graphics.BLUE));
        super.g.drawRect(super.x-5, super.y-5, super.w+9, super.h+9);
        super.g.drawRect(super.x-4, super.y-4, super.w+7, super.h+7);
        super.g.unlock(true);
    }

    /**
     * tH[JX폜܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B
     */
    protected void resetFocus() {
        // tH[JXÕobNobt@`
        super.g.lock();
        super.g.drawImage(imf, super.x-5, super.y-5);
        super.g.unlock(true);
        imf = null;
    }

    /**
     * iIANVs܂B<br>
     * @return Cxg̃^CvԂ܂B
     */
    protected int actionSelect() {
        return CostumePanel.BUTTON_PRESSED;
    }

    /**
     * iړANVs܂B<br>
     * @param num ANVԍn܂B-1:O 1:
     * @return  false Ԃ܂B
     */
    protected boolean actionPosition(int num) { return false; }

    /*
     * `
     */
    private String  text = "";          // x
    private Image   imf  = null;        // tH[JXO摜
}
