/*
 * CBulletinBoard.java
 *
 * AvJX^pl ue{[h
 *
 * Copyright ITmarks Inc. All rights reserved.
 */
package iappli.lib.ui;

import com.nttdocomo.ui.Graphics;

/**
 * Canvasɕ`悷fłB<br>
 *
 * <pre>
 * yz
 * class Dialog extends CostumePanel {
 *   CBulletinBoard cb = new CBulletinBoard("Ėڟ",
 *           "y͔LłBO͂܂ȂB\n䂦ɁBBB",
 *           Graphics.getColorOfName(Graphics.BLACK),
 *           Graphics.getColorOfRGB(200, 200, 200, 200),
 *           Graphics.getColorOfName(Graphics.WHITE));
 * 
 *   public void paint(Graphics g) {
 *   
 *     cb.show(g, 4, 3, 30, 10, true);
 *         F
 *   }
 * 
 *   public void processEvent2(CComponent c, int t, int p) {
 *     if (t == Display.KEY_PRESSED_EVENT && p == Display.KEY_SELECT) {
 *       cb.clear();
 *     }
 *   }
 * }
 * </pre>
 */
public final class CBulletinBoard extends iappli.lib.ui.CComponent {

    /**
     * f𐶐܂B<br>
     */
    public CBulletinBoard() {
        this(null);
    }

    /**
     * fw肵Čf𐶐܂B<br>
     * 
     * f́A𒴂Ǝs܂B
     * ܂A\n w肷Ɖs܂B
     *
     * @param text  f̌fw肵܂B
     */
    public CBulletinBoard(String text) {
        this.text = text;

        if (this.text == null) {
            this.text = "";
        }
    }

    /**
     * ^CgAfAwiFAOiFAetFw肵Čf𐶐܂B<br>
     * 
     * f́A𒴂Ǝs܂B
     * ܂A\n w肷Ɖs܂B<br>
     * ^Cg null w肵ꍇA^Cg͕̈`悳܂B<br>
     * 
     *
     * @param title f̃^Cgw肵܂B
     * @param text f̌fw肵܂B
     * @param c1   OiFw肵܂B
     * @param c2   wiFw肵܂B
     * @param s    etFw肵܂B
     */
    public CBulletinBoard(String  title,
                          String  text,
                          int     c1,
                          int     c2,
                          int     s)
    {
        this(text);

        this.title = title;

        super.fgcolor = c1;
        super.bgcolor = c2;
        super.setShadow(s);
    }

    /**
     * f̌fݒ肵܂B<br>
     * 
     * f́A𒴂Ǝs܂B
     * ܂A\n w肷Ɖs܂B<br>
     * Ac𒴂ꍇ͍l܂B
     *
     * @param text f̌fw肵܂B
     *              null w肳ꂽꍇ͋󕶎("")ݒ肳܂B
     */
    public void setLabel(String text) {
        this.text = text;
        if (this.text == null) {
            this.text = "";
        }
    }

    /**
     * f̃^Cgݒ肵܂B<br>
     *
     * @param title f̃^Cgw肵܂B
     *               null w肳ꂽꍇA^Cg\܂B
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * f`悵܂B<br>
     * 
     * `撆̃OtBbNXIuWFNǵAlockAunlock s܂B
     * ĂяoɂĎsĂB
     * f̓tH[JX܂B<br>
     *
     * @param g LpX̃OtBbNXIuWFNg(getGraphics())w肵܂B
     * @param x W()w肵܂B
     * @param y cW()w肵܂B
     * @param w ()w肵܂B
     * @param h c()w肵܂B
     * @param b truew肷ƕ`OobNAbv܂B
     *           (q[v邽ߎgȂꍇ false w肵ĂB)
     */
    public void show(Graphics g, int x, int y, int w, int h, boolean b) {
        
        // `ς݂폜
        clear();
        
        // 擾
        int fw = super.f.getBBoxWidth(" ");  // tHg̉
        int fh = super.f.getBBoxHeight(" "); // tHg̏c
                                             // tHgx[XC̎擾 (@ˑ)
        int bl = (super.f.getHeight() - super.f.getAscent() - 2) * -1;

        // W𕶎Ŏw
        x = x * fw;
        y = y * fh;
        w = w * fw;
        h = h * fh;

        synchronized (this) {
            // ޔ
            super.x = x;
            super.y = y;
            super.w = w + 12;
            super.h = h + 12;
            super.backup = b;
            super.g = g;
        }

        // obNAbvL̏ꍇACanvas̉摜ޔ
        super.backupImage();

        /*
         * f`
         */
        // fg`
        g.setColor(super.bgcolor);
        g.fillRect(x, y, w+8, h+6);
        g.setColor(Graphics.getColorOfRGB(100, 100, 100));
        g.drawRect(x+1, y+1, w+5, h+6);

        g.drawLine(x+2, y+2, x+2,   y+h+6);
        g.drawLine(x+2, y+2, x+w+5, y+2);
        g.setColor(Graphics.getColorOfRGB(200, 200, 200));
        g.drawLine(x+3, y+h+6, x+w+5, y+h+6);
        g.drawLine(x+w+5, y+3, x+w+5, y+h+6);

        g.drawLine(x, y, x,     y+h+8);
        g.drawLine(x, y, x+w+7, y);
        g.setColor(Graphics.getColorOfRGB(100, 100, 100));
        g.drawLine(x+1,   y+h+8, x+w+7, y+h+8);
        g.drawLine(x+w+7, y+1,   x+w+7, y+h+8);

        // ^Cg`
        if (title != null) {
            g.setColor(Graphics.getColorOfRGB(50, 50, 100));
            g.fillRect(x+3, y+3, w+2, fh);
            g.setColor(Graphics.getColorOfName(Graphics.WHITE));
            g.drawString(title, x+w/2-title.getBytes().length*fw/2+6, y+fh+bl);
            y += fh;
        }

        // fbZ[W`
        y += fh + 2;
        int p = x + 6;
        for (int i = 0; i < text.length(); i++) {
            // s
            if (text.substring(i, i+1).equals("\n")) {
                p = x + 6;
                y += fh;
            }
            else {
                // et̕`
                if (super.sdflag) {
                    g.setColor(super.sdcolor);
                    g.drawString(text.substring(i, i+1), p-1, y+bl+1);
                }
                // ̕`
                g.setColor(super.fgcolor);
                g.drawString(text.substring(i, i+1), p-2, y+bl);

                p+=text.substring(i, i+1).getBytes().length*fw;

                // g𒴂ꍇ͎s
                if ((p+6) > x+w) {
                    p = x + 6;
                    y += fh;
                }
            }
        }
    }
    
    /**
     * tH[JXݒ肷B<br>
     */
    protected void setFocus() {  }

    /**
     * tH[JX폜B<br>
     */
    protected void resetFocus() {  }

    /**
     * iIANVs܂B<br>
     * @return  -1 Ԃ܂B
     */
    protected int actionSelect() { return -1; }

    /**
     * iړANVs܂B<br>
     * @param num ANVԍn܂B-1:O 1:
     * @return  false Ԃ܂B
     */
    protected boolean actionPosition(int num) { return false; }

    /*
     * `
     */
    private String  text  = "";         // f
    private String  title = null;       // ^Cg
}
