/*
 * CCanvasFade.java
 *
 * AvJX^pl tF[hCEAEg
 *
 * Copyright ITmarks Inc. All rights reserved.
 */
package iappli.lib.graphics;

import iappli.lib.ui.CostumePanel;

import com.nttdocomo.ui.Canvas;
import com.nttdocomo.ui.Display;
import com.nttdocomo.ui.Graphics;
import com.nttdocomo.ui.Image;

/**
 * (Canvas)܂͉摜̐؂ւX[YɍsȂ܂B<br>
 * {NX́A{@link CostumePanel}KvƂ܂B<br>
 * 
 * <pre>
 * yz
 * class Test extends CostumePanel {
 * 
 *   CButton bt = new CButton("{^");
 * 
 *   public void paint(Graphics g) {
 * 
 *     bt.show(g, 10, 10, true);
 *     addEvent(bt);
 *         F
 *   }
 * 
 *   public void processEvent2(CComponent c, int t, int p) {
 *     if (c == bt &&
 *         t == CostumePanel.BUTTON_PRESSED) {
 *       Canvas c1 = new Test2();
 *       CCanvasFade.fade(CCanvasFade.FADE_BLENDIMAGE, this, c1, 5);
 *     }
 *   }
 * }
 * </pre>
 */
public class CCanvasFade {

    /**
     * uChCtF[hł(={@value})B<br>
     * 摜P摜QɂPCÂJڂ܂B
     * QOĂ̂ŏcSOsNZȏ̃C[Ww肵ĂB
     */
    public static final int FADE_BLINDLINE = 1;

    /**
     * uhC[WtF[hł(={@value})B<br>
     * 摜PƉ摜Q𓧉߂ȂJڂ܂B
     */
    public static final int FADE_BLENDIMAGE = 2;

    /**
     * {NX̃CX^X𐶐邱Ƃ͂ł܂B
     */
    protected CCanvasFade() {  }

    /**
     * CanvasŜ̐؂ւs܂B<br>
     * Jg̓tF[h̃LpXɂȂ܂B<br>
     * tF[h̉ʃC[W擾ɂ́A
     * LpX(c2)paint()\bhsĂ܂B<br>
     * ȂׂApaint()\bh͕`揈݂̂sȂ悤ɂĂB<br>
     * 
     * @param type tF[h̎ނw肵܂B
     * @param c1 tF[hÕLpXw肵܂B
     * @param c2 tF[h̃LpXw肵܂B
     * @param s  tF[h̑w肵܂B 1 ` 10
     */
    public static void fade(int    type,
                            Canvas c1,
                            Canvas c2,
                            int    s) {

        int x = 0;
        int y = 0;
        int w = Display.getWidth();
        int h = Display.getHeight();

        // tF[hOCanvas̃C[W擾
        Display.setCurrent(c1);
        int pd[] = c1.getGraphics().getRGBPixels(x, y, w, h, null, 0);
        Image im1 = Image.createImage(w, h, pd, 0);

        // tF[hCanvas̃C[WImageɕ`悷
        Graphics g = Image.createImage(w, h).getGraphics();
        c2.paint(g);
        int pd2[] = g.getRGBPixels(x, y, w, h, null, 0);
        Image im2 = Image.createImage(w, h, pd2, 0);

        // tF[hCanvasփJg؂ւ
        g = c2.getGraphics();
        g.drawImage(im1, x, y);
        Display.setCurrent(c2);

        // LpX̃C[WŐ؂ւs
        CCanvasFade.fade(type, g, im1, im2, 0, 0, s);
    }

    /**
     * C[W̐؂ւs܂B<br>
     * 
     * `悷C[W̕ƍ́AtF[hÕC[W̃TCYɂȂ܂B
     * ̂߁AtF[h̃C[ẂAtF[hÕC[W蓙
     * 傫Ȃ΂Ȃ܂B<br>
     * tF[hOÃC[Wɐ؂C[Ww肷΁A
     * IȃtF[h\ɂȂ܂B<br>
     * `撆̃OtBbNXIuWFNǵAlockAunlock ܂B
     *
     * @param type tF[h̎ނw肵܂B
     * @param g    `悷OtBbNXIuWFNgw肵܂B
     * @param im1  tF[hÕC[Ww肵܂B()
     * @param im2  tF[h̃C[Ww肵܂B(ύX)
     * @param x    `ʒûwWw肵܂B
     * @param y    `ʒûxWw肵܂B
     * @param s    tF[h̑w肵܂B 1 ` 10
     */
    public synchronized static void fade(int      type,
                                         Graphics g,
                                         Image    im1,
                                         Image    im2,
                                         int      x,
                                         int      y,
                                         int      s) {
        // tF[hOC[W̃TCY擾
        int w = im1.getWidth();
        int h = im1.getHeight();

        // tF[h̑ 1`10 ͈̔͂ɂ
        if (s < 1) {
            s = 1;
        }
        else if (s > 10) {
            s = 10;
        }

        /*
         * tF[h
         */
        // uChCtF[h
        if (type == CCanvasFade.FADE_BLINDLINE) {
            for (int i = 0; i < h/20; i++) {
                // C[WQOĂPCɕ`
                for (int j = 0; j < 20; j++) {
                    g.lock();
                    g.drawImage(im2, x, y+i+j*(h/20), x, y+i+j*(h/20), w, i);
                    g.unlock(true);
                }
                try {
                    Thread.sleep(s*10);
                } catch (InterruptedException e) {  }
            }
        }
        // uhC[WtF[h
        else if (type == CCanvasFade.FADE_BLENDIMAGE) {
            for (int i = 0; i < 255; i+=(21-s*2)) {
                // C[W̃At@lւ
                g.lock();
                g.clearRect(x, y, w, h);
                im1.setAlpha(255-i);
                g.drawImage(im1, x, y);
                im2.setAlpha(i);
                g.drawImage(im2, x, y);
                g.unlock(true);
            }
        }
    }
}
